/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.datax;

import java.util.*;

/**
 * Class to represent statistics.  The Statistics are in the form of a <String, Object> pair and
 * can be set & looked up this way.  
 */
public class Stats
{
	Hashtable ht;

	/**
	 * Default constructor for the statistics object.
	 */
	public Stats ()
	{
		ht = new Hashtable();	
	}
	
	/**
	 * Add a new stat. if the string name is already in use, it will overwrite the old value.
	 * @param key lookup name
	 * @param value The key's value
	 */
	public void addStat(String key, Object value)
	{
		ht.put(key, value);
	}
	
	/**
	 * Finds the value of a stat.
	 * @param key The loookup name
	 * @return The result of the lookup. null if the key is not a valid key.
	 */
	public Object getStat(String key)
	{
		return ht.get(key);
	}
	
	/**
	 * Returns an enumeration (of strings) of the various stat names that are in the Stats object.
	 * @return Enumeration of the Strings in the keys.
	 */
	public Enumeration statKeys()
	{
		return ht.keys();
	}
	
	
	/**
	 * Removes all stats from the database.
	 */
	public void clearStats()
	{
		ht.clear();
	}
	
	/**
	 * Takes a stats object and merges it with the current object. Note: The current object is 
	 * changed by adding the pairs of the second object. <p>
	 * @param s Stats object to merge with.
	 * @return The new stats object.
	 */
	public Stats merge(Stats s)
	{
		if (s!= null)
		{
			String key;
			for (Enumeration e = s.ht.keys(); e.hasMoreElements() ;  )
			{
				key = (String)(e.nextElement());
				addStat(key , s.ht.get(key));
			}
			return this;
		}
		
		return new Stats();
	}

	/**
	 * Method to get a string form of the statistics.
	 * @return String the string version of the statistics
	 */
	public String toString()
	{
		String s = "";
		String key;
		
		for (Enumeration e = ht.keys(); e.hasMoreElements() ; )
		{
			key = (String)e.nextElement();
			s += key + ": " + ht.get(key) + "\n";
		}
		return s;
	}   
}
